//
//  Home.swift
//  Do It
//
//  Created by Jim Dovey on 5/20/20.
//  Copyright © 2020 Pragmatic Programmers. All rights reserved.
//

import SwiftUI

struct Home: View {
    var body: some View {
        NavigationView {
            List {
                Section {
                    NavigationLink(destination: TodoList()) {
                        Row(name: "All Items",
                            icon: "list.bullet",
                            color: .gray)
                    }
                }
                
                Section {
                    ForEach(defaultTodoLists) { list in
                        NavigationLink(destination: TodoList(list: list)) {
                            Row(name: list.name,
                                icon: list.icon,
                                color: list.color.uiColor)
                        }
                    }
                }
            }
            .font(.system(.headline, design: .rounded))
            .listStyle(GroupedListStyle())
            .navigationBarTitle("Lists")
        }
    }
    
    private struct Row: View {
        var name: String
        var icon: String
        var color: Color
        
        var body: some View {
            HStack {
                Image(systemName: icon)
                    .foregroundColor(.white)
                    .frame(width: 32, height: 32)
                    .background(color)
                    .clipShape(Circle())
                Text(name)
            }
        }
    }
}

struct Home_Previews: PreviewProvider {
    static var previews: some View {
        Home()
    }
}
